# 🛠️ Tools & Projects

Our practical tools for digital resilience are developed openly on Codeberg, a European-based platform that aligns with our values of privacy and digital sovereignty.

## 🧰 Active Projects

### Ardens – AI Resilience Tools
**Repository:** [codeberg.org/resilience/Ardens](https://codeberg.org/resilience/Ardens)

A collection of tools focused on AI transparency and user rights, starting with:

- **LLM Deletion Field Kit** – Document when AI systems delete messages mid-conversation
- *More tools in development for AI accountability and transparency*

**Languages:** English, Deutsch, Polski, Français  
**License:** Code – EUPL 1.2 | Documentation – CC BY-ND 4.0

### OTFR – Open Tools For Resilience
**Repository:** [codeberg.org/resilience/OTFR](https://codeberg.org/resilience/OTFR)

The framework and documentation hub for our resilience tools approach:

- Project mission, vision, and principles
- Multi-language documentation (EN, DE, PL, FR)
- Contribution guidelines and community standards

**Languages:** English, Deutsch, Polski, Français  
**License:** Documentation – CC BY-ND 4.0

## 🌍 Development Philosophy

**European Experience, Global Tools**
Our tools are developed through European digital rights advocacy but designed for global adaptation. We focus on practical solutions that work across different legal systems and cultural contexts.

**Open by Default**
All development happens publicly on Codeberg with transparent issue tracking, discussions, and decision-making.

**Multilingual from the Start**
We prioritize German, Polish, and French alongside English to ensure our tools are accessible across Europe and beyond.

## 🤝 How to Engage

**For Users**
- Try our tools and provide feedback
- Report issues or suggest improvements
- Share your experiences adapting tools to your context

**For Contributors**
- Translate documentation into more languages
- Help improve existing tools or suggest new ones
- Participate in discussions on Codeberg

**For Developers**
- Fork repositories and submit pull requests
- Help maintain and improve the technical infrastructure
- Develop integrations or extensions

---

*All tools are part of the OTFR (Open Tools For Resilience) initiative.*  
*Documentation hub: [Treemagic.org](https://treemagic.org) • Development: [Codeberg.org/resilience](https://codeberg.org/resilience)*
