# OTFR Mission

## Why We Exist

In an increasingly centralized, automated, and opaque digital landscape, individuals and communities need practical tools to maintain autonomy, exercise rights, and build resilience. OTFR exists to create and curate these tools as open, adaptable public goods.

## What We Do

### 1. Develop Practical Tools
- Create usable software and templates for exercising digital rights
- Focus on real-world scenarios (data deletion, transparency requests, etc.)
- Ensure tools work across different platforms and jurisdictions

### 2. Document What Works
- Research and share patterns that succeed across different legal systems
- Create adaptable templates for complaints, requests, and advocacy
- Build knowledge bases that help users navigate complex systems

### 3. Build Translatable Frameworks
- Design tools with multi-language support from the beginning
- Create documentation structures that facilitate translation
- Engage communities in localizing tools for their contexts

### 4. Connect Diverse Approaches
- Bridge technical implementations with legal requirements
- Connect individual tools to collective advocacy strategies
- Link European experiences with global adaptation needs

## How We Work

### Development Philosophy
- **User-centered**: Tools must solve real problems for real people
- **Open by default**: Code, issues, and discussions are public
- **Iterative improvement**: Start minimal, evolve based on use

### Collaboration Model
- **Code development**: Hosted on Codeberg with public issue tracking
- **Documentation**: Centralized on Treemagic.org with MkDocs
- **Translations**: Community-driven through structured file management

### Licensing Approach
- **Code (EUPL 1.2)**: Ensures derivatives remain open while allowing commercialization
- **Documentation (CC BY-ND 4.0)**: Protects integrity while allowing sharing
- **Transparency**: Clear licensing helps users understand their rights

## Success Metrics

### Short-term (6-12 months)
- [ ] Tools used in at least 3 different European countries
- [ ] Community contributions from 4+ language groups
- [ ] Successful adaptation to 2+ non-European legal contexts

### Medium-term (1-2 years)
- [ ] Tools referenced or used by established digital rights organizations
- [ ] Self-sustaining translation community for priority languages
- [ ] Documented case studies of tool effectiveness

### Long-term vision
- A thriving ecosystem of resilience tools maintained by a global community
- Regular updates adapting to changing technological and legal landscapes
- Recognition as a reliable source for practical digital rights tools

## Getting Involved

### For Users
- Use the tools and provide feedback on what works/doesn't
- Share your experiences adapting tools to your context
- Help identify gaps where new tools are needed

### For Translators
- Translate documentation into additional languages
- Help improve existing translations for clarity
- Create localization guides for different regions

### For Developers
- Contribute code improvements or new tools
- Help maintain the technical infrastructure
- Develop integrations with other platforms

### For Advocates
- Test tools in real advocacy scenarios
- Document successful use cases and strategies
- Help bridge tool development with policy work
