# OTFR Framing: Open Tools For Resilience

## Core Principles
  ![Resilience](https://treemagic.org/OTFR/images/resilience-hardik-jogani-onux-unsplash.jpg)
  
<font size="2"> Resilience- Hardik Jogani | Free to use under the Unsplash License

---

### 1. Global Roots, Global Reach
- Tools developed through European and North American digital rights advocacy experience
- Designed for adaptation to any legal jurisdiction worldwide
- EU regulatory frameworks (GDPR) as a starting point, not a limitation

### 2. Resilience Over Compliance
- Move beyond mere legal compliance to practical user empowerment
- Build tools that work when systems fail, resist, or are opaque
- Foster community knowledge sharing as a collective defense mechanism

### 3. Modular & Adaptable by Design
- Each tool can stand alone but connects to a broader ecosystem
- Architecture built for localization and cultural adaptation
- Clear licensing separation: code (EUPL) vs. documentation (CC BY-ND)

### 4. Multi-Language from Inception
- English as the development baseline, not the only language
- Priority support for German, Polish, and French (EU frontline languages)
- Framework designed to incorporate additional languages seamlessly

## Strategic Positioning

### What OTFR Is
- **Global tools** built with European/US regulatory experience
- **Practical solutions** that bridge legal, technical, and user perspectives
- **Open ecosystem** where code, docs, and community evolve together

### What OTFR Is Not
- **Not Exclusive** - Tools are designed for global adaptation
- **Not just for lawyers** - Accessible to users, advocates, and developers
- **Not a standards body** - We build tools, not mandates

## Implementation Framework

### Licensing Strategy
- **All source code**: EUPL 1.2 (European Union Public License)
- **All documentation**: CC BY-ND 4.0 (Creative Commons Attribution-NoDerivatives)  
- **Legal templates**: CC BY-SA 4.0 (ShareAlike for collaborative improvement)

### Development & Documentation
- **Primary code hosting**: Codeberg.org (EU-based, open source)
- **Documentation hub**: Treemagic.org (MkDocs-based knowledge center)
- **Community coordination**: Multi-language issue tracking and discussions
