# 🛰️ Strategic Intelligence Gateway: User Cheatsheet

The Strategic Intelligence Gateway provides real-time global monitoring by analyzing millions of news reports in over 100 languages. Use this guide to maximize your extraction accuracy.

## 🛡️ Core Capability
- **Speed:** Updates every 15 minutes.
- **Scope:** Monitors global online news, including local non-Western media.
- **Verification:** Use the **Safety Portal** links in the sidebar for verified human-coded data (ACLED/GDACS).

## 🔍 Advanced Search Operators
Refine your drilldown with these logic-based operators:
- **Exact Phrases:** `"vessel hijacked"` (finds that specific wording).
- **Boolean OR:** `(Gaza OR Lebanon) airstrike` (finds results for either location).
- **Exclusion:** `piracy -movie -book` (removes noise from entertainment or literature).
- **Proximity:** `near10:"tank border"` (finds words within 10 positions of each other).
- **Source Filter:** `domain:reuters.com` (limits extraction to a trusted outlet).

## 🌐 Multilingual Intelligence
- **Native Search:** You can enter queries in French, Russian, Chinese, or Arabic.
- **Translingual Bridge:** GDELT automatically translates news into English. If a search in a local language returns "Sparse Signals," try the English equivalent to tap into the full translated global archive.

## 🛰️ UI Status Indicators
- **🟢 Green Dot:** Extraction successful; live signals detected.
- **🟡 Yellow Dot:** Tactical processing active (fetching from GDELT API).
- **🔵 Blue Dot:** Multilingual extraction active (non-English characters detected).
- **🟠 Orange Dot:** Sparse signals detected. Re-evaluate keywords.
- **🔴 Red Dot:** No matches found or API connection error.

## 💡 Pro-Tips for Analysts
1. **The 48h Window:** The gateway defaults to a 48-hour "Operational" window to ensure data is fresh and actionable.
2. **Context Popups:** Click any indicator on the map to see the specific article snippet and original source link.
3. **Slow Connections:** A tactical spinner appears during extraction to confirm the system is actively communicating with the GDELT servers.
