# OTFR Real-Time Situation Maps

Ground-truth awareness for underreported crises — open-source prototypes for journalists, aid workers, coordinators, and communities.

**The Vision**
>These are not maps in the traditional sense. These tools are evolving into a combination of early warning systems and situation descriptors (verbal & visual) designed for exploration and understanding. Rather than a static image, these situation-maps provide a living basis for learning and foresight—built from real-time alerts, insights, and ground-truth.

**Proof of Concept Series**  
These maps use freely available public data sources (USGS, NASA FIRMS, GDACS, Liveuamap, Insecurity Insight, DeepStateMap). Full, detailed, armed conflict layers are available upon provision of valid ACLED access credentials.

### Available Maps
- **[Strategic Intelligence Gateway- GDELT](https://treemagic.org/situation-maps/Strategic-Intelligence-Gateway.html)**  
  Internet Connection REQUIRED. A customized version of [GDELT](https://www.gdeltproject.org/). "GDELT monitors and analyzes the world's news media in over 100 languages to create a realtime open data platform for computing on human society. Explore events, themes, emotions, networks, images and more from nearly every corner of the world."
***
- **[Caribbean / Haiti Insecurity](https://treemagic.org/situation-maps/caribbean-region.html)** (POC)  
  Attacks on aid, health & education workers (Insecurity Insight) + regional disaster alerts (GDACS).  
  Full gang violence & conflict layer (ACLED) available with your credentials.
- **[DRC Situation](https://treemagic.org/situation-maps/drc-conflict.html)** (POC)  
  Humanitarian alerts (floods, displacement – GDACS) + crowdsourced conflict reports (Liveuamap).  
  Full ACLED upgrade (M23 advances, ADF/CODECO attacks, civilian violence) ready with your credentials.
- **[Global Disasters](https://treemagic.org/situation-maps/disaster-map.html)**  
  Real-time earthquakes (USGS), active fires (NASA FIRMS MODIS), major events & displacement alerts (GDACS). Mobile-friendly, time-filterable.
- **[Human Rights Safety](https://treemagic.org/situation-maps/human-rights-events.html)**
  Human Rights Violations. 
  Full ACLED upgrade ready with your credentials.
- **[Hybrid Attacks](https://treemagic.org/situation-maps/Hybrid-Attacks-on-Infrastructure.html)**
  Hybrid Attack Reports. 
  Full ACLED upgrade ready with your credentials.
- **[Myanmar Conflict](https://treemagic.org/situation-maps/myanmar-conflict.html)**
  Civil Conflict/War/Genocide. 
  Full ACLED upgrade ready with your credentials.
- **[Shadow Fleets](https://treemagic.org/situation-maps/Shadow-Fleets-Live-Map.html)** (POC)  
  Known high-risk zones for sanctions-evading tankers (STS transfers, AIS-off anchorages) with example sanctioned vessels.  
  Live AIS & dark fleet tracking upgrade available with your premium data license.
- **[Sudan Conflict](https://treemagic.org/situation-maps/sudan-conflict.html)** (POC)  
  Displacement & flood alerts (GDACS) + crowdsourced/OSINT reports (Liveuamap).  
  Full ACLED layer (RSF vs SAF clashes, airstrikes, civilian impacts) available with your credentials.
- **[Ukraine Conflict](https://treemagic.org/situation-maps/Ukraine-Conflict-Live-Map.html)** (POC)  
  Live clash/airstrike reports upgrade (Liveuamap/ACLED) available with your credentials.

All maps are standalone, no-install, mobile-friendly, and built on open standards (live data requires internet).

Interested in richer conflict data, custom views, or integration?  
Provide ACLED access details (or other premium sources) and we'll upgrade immediately.

*Open source · Non-commercial · Humanitarian focus*

## ⚙️ The Codeberg Difference: Documents / Software
The Resilience Hub contains **documentation and protocols**.  
If you are looking for executable code, automation scripts, software to *implement* these tools at scale, or markdown/pdf to translate or distribute, please visit our dedicated development repositories:

**[Codeberg Repositories ➡️](https://codeberg.org/resilience)**
