# OTFR Situation Maps: User Manual (2025)

**Live, standalone intelligence platforms for humanitarian awareness.**
*No installation, no Python environment, and no local server required.*

---

## 🚀 Getting Started

To use any of the maps, simply **open the `.html` file** in any modern web browser on your computer or mobile device.

* **Live Connectivity:** The maps require an internet connection to pull the latest reports from global APIs and news feeds.
* **Automatic Updates:** Every time you open or refresh the page, the map fetches the most recent data available.

---

## 🛠️ Key Features

These maps use a "Zero-Install" architecture to ensure they work out of the box:

* **Live Humanitarian APIs:** Maps for the DRC, Sudan, and Haiti query the **ReliefWeb API** directly for the latest conflict and aid reports.
* **Disaster Alerts:** Integrated **GDACS** (Global Disaster Alert & Coordination System) feeds show floods, volcanoes, and earthquakes in real-time.
* **CORS Proxy Integration:** All maps use a built-in proxy (`allorigins.win`) to bypass browser security blocks, allowing them to load live news from Reuters, DW, and other RSS sources without a local script.

## 🗺️ Available Maps Gallery

| Map Name | Primary Intelligence Source | Key Data Tracked |
| --- | --- | --- |
| **Hybrid Attacks** | Custom RSS / Reuters | Infrastructure sabotage, cable cuts, GPS jamming. |
| **DRC Situation** | ReliefWeb & GDACS | M23/ADF conflict reports, floods, and displacement. |
| **Sudan Conflict** | ReliefWeb | RSF/SAF clashes and humanitarian crisis updates. |
| **Haiti / Caribbean** | ReliefWeb & Insecurity Insight | Gang violence, aid worker security, and regional disasters. |
| **Ukraine Conflict** | DW News & Community GeoJSON | Occupied territories and frontline news updates. |
| **Shadow Fleets** | Reuters Shipping | Sanctions-evasion hotspots and STS transfer zones. |
| **Human Rights** | ReliefWeb (Legal Theme) | Global reports on humanitarian law and rights events. |

---

### 1. Overview

The **Hybrid Attacks Panel** is a real-time situational awareness tool designed to track non-linear warfare targeting critical infrastructure, such as power grids, undersea cables, and transport networks. This guide explains how to use the dashboard and how to load custom intelligence feeds.

### 2. Interface Layout

* **Main Map**: Displays 2025 "Hotspots" (static known targets) and "Live Events" (real-time reports).
* **Legend (Bottom-Right)**: Identifies marker types—Red for Power, Orange for Comms/Cables, and Blue for Live Intel.
* **Latest Reports (Right Panel)**: A scrollable feed of news headlines with direct links to sources.
* **Custom Feed Panel (Top-Left/Center)**: Allows you to input your own data source URLs from **RSS.app**.

### 3. Loading a Custom Feed

The prototype is "patched" to handle complex CSV data exported from RSS services. To load your own intelligence:

1. **Generate a URL**: Create a CSV export URL using a service like RSS.app with keywords such as `"GPS jamming"` or `"undersea cable"`.
2. **Input URL**: Paste the URL into the **Custom CSV Feed URL** box.
3. **Click "Load Feed"**: The "Latest Reports" list will clear and populate with your specific headlines.

### 4. Technical Troubleshooting

* **CORS Errors**: The tool uses `corsproxy.io` to bypass browser security restrictions when fetching external news feeds. If a feed fails to load, ensure the proxy service is reachable.
* **Parsing Logic**: The "Patched" logic includes a **Robust CSV Parser**. This ensures that if a news headline contains a comma (e.g., "Attack in London, UK"), the dashboard will not break or misalign columns.
* **Layer Controls**: Use the layer control (top-left) to toggle specific infrastructure types. If "Live Events" are cluttered, uncheck that layer to focus on strategic hotspots like the **Baltic Sea Cables** or **Ukraine Power Grid**.

### 5. Advanced: Caching for Reliability

For field use where internet may be intermittent, follow the **Custom RSS Feeds Guide** to use the provided Python script (`cache_hybrid_feed.py`). This script saves the last 50 intelligence items as a local JSON file, which can be loaded as a reliable fallback.

## ❓ FAQ & Troubleshooting

* **The feed is blank:** Ensure you have an active internet connection. If you are using a custom RSS URL, verify it is a valid XML link.
* **Map loading slowly:** The maps fetch data from several global servers at once. If an API (like ReliefWeb) is under heavy load, markers may take a few seconds to appear.
* **Do I still need the Python script?** Only if you need to **archive** data for 90+ days or if you are hosting the maps in an environment with no outgoing internet access. For general use, it is not required.

---

*This guide is part of the OTFR Real-Time Situation Maps series, focused on ground-truth awareness for humanitarian and OSINT practitioners.*

