# OTFR-Tails

**OTFR Tools for Tails Linux Persistence**  
Free, open-source digital resilience tools for people and populations in distress — optimized for **Tails** (The Amnesic Incognito Live System).

### Why Tails + OTFR?
- Maximum security & privacy (Tor by default, amnesic mode)
- Encrypted persistent storage for tools/files
- Trusted by journalists, activists, and humanitarian workers worldwide
- No custom OS maintenance — always the latest secure Tails

This repository contains everything needed to add OTFR tools to your Tails persistent volume.

### Download the Package
- [**Primary Site (click to download)**](https://treemagic.org/OTFR-Tails-Package.tar.gz)
- **Source & backup**: https://codeberg.org/resilience/OTFR-Tails (clone or download ZIP)

### Contents
- `Emergencies/` — Crisis checklists & protocols
- `otfr/` — Core low-tech tools (verification, encryption, secure comms)
- `situation-maps/` — Offline-capable situation maps + bookmarks
- `.config/` — Optional dotfiles for shortcuts and custom configs

### Stupid-Simple Setup
1. **Download & boot the latest Tails**  
   https://tails.net/install/ (always verify the signature!)

2. **Create encrypted persistent storage**  
   Applications → Tails → Configure persistent storage  
   - Enable **Persistent Folder** (required)  
   - Optional: **Dotfiles** (for shortcuts/configs)

3. **Add the OTFR package**  
   - Download the `.tar.gz` or clone the repo  
   - Unlock persistence at boot  
   - Extract/copy contents to the **Persistent** folder:

 Persistent/
 └── OTFR/ 
 ├── Emergencies/
 ├── otfr/
 ├── situation-maps/
 └── .config/ (optional)

4. **Create shortcuts** (optional but recommended)  
Right-click important files/folders → Make Link → Drag links to Desktop

5. Done — tools ready on every boot (just unlock persistence with your passphrase)

### Security Notes
- All network traffic automatically routed through Tor
- Full shutdown leaves no traces on the host computer
- Tails updates itself securely (follow prompts)
- To update OTFR tools: re-download the package and replace in Persistent/OTFR/

Questions, requests, or feedback?  
mark@eireicon.org

Go forth and do good.

— Mark Rabideau / eirenicon llc / TreeMagic / ManyRoads  
https://treemagic.org/OTFR/
