# "Call for Aid" Protocol: Seeking Help & Contact

**Goal:** Safely and efficiently communicate your distress, location, and needs to access support services or trusted contacts.
*Focus: Clear, secure steps for communicating distress and accessing support.*

| Step | Action: What You Must Do Now | Why This Saves You (Survival Rationale) | Communication Focus |
| :--- | :--- | :--- | :--- |
| **1. The Distress Message** | Prepare a **single, clear, and concise message** with three details: **WHO** you are, **WHERE** you are (as specific as possible), and **WHAT** you need (e.g., medical aid, shelter, exfiltration). | Rescuers and contacts need specific information immediately. Long, vague messages waste time. | *Communication Clarity* |
| **2. Use Secure Channels** | **ONLY** use your secure, end-to-end encrypted messaging app (**Signal**) to contact your primary trusted helper. Do not use public social media or unencrypted email/SMS. | Encrypted channels ensure your distress call and your location are not intercepted by hostile parties. | *Secure FOSS Use* |
| **3. Prepare Proof of Life** | Agree on a **simple, pre-arranged code word or question** with your trusted contacts that only they would know the answer to. | In a high-risk situation, this ensures you are communicating with the actual person you trust, and not an impersonator. | *Identity Verification* |
| **4. Check-In Window** | Agree on a **specific time frame** to check in with your contact (e.g., "I will message you between 18:00 and 19:00"). If you miss this window, they should know to escalate your situation. | A predictable, shared schedule allows for effective monitoring and triggers aid when contact is lost. | *Logistics and Support* |
| **5. Low-Power Contact** | If your battery is low, use only a **very brief text-based message** over a secure app. Avoid voice calls or photo/video attachments. | Text uses far less power and bandwidth, maximizing the chances that your single, critical message gets through before the battery dies. | *Low-Bandwidth/Power Resilience* |

