# The FOSS Toolkit: Preparation Guide

The resilience protocols ("Go Quiet," "Connect Smart," "Hide and Save") rely on simple actions and trusted, community-driven tools. This toolkit lists the recommended **Free and Open Source Software (FOSS)** that you should download, install, and practice using *now*, while you still have a stable, safe internet connection.

FOSS tools are critical because their code is public, meaning security experts around the world can inspect them for hidden flaws or backdoors, offering the highest level of trust.

## 1. Tools for the "Go Quiet" Protocol (Communication & Identity)

| Tool | Purpose | FOSS Project Link |
| :--- | :--- | :--- |
| **Signal** | Secure, end-to-end encrypted messaging and calling. Use this for all sensitive communications. | [https://signal.org/](https://signal.org/) |
| **Tor Browser** | Hides your identity and location online by routing your connection through multiple relays. Essential for accessing sensitive information safely. | [https://www.torproject.org/](https://www.torproject.org/) |
| **KeePassXC** | Securely stores all your complex passwords and passphrases in one encrypted file, which you unlock with only one master passphrase. | [https://keepassxc.org/](https://keepassxc.org/) |

## 2. Tools for the "Connect Smart" Protocol (Network Resilience)

| Tool | Purpose | FOSS Project Link |
| :--- | :--- | :--- |
| **Quad9** | A secure, free, public DNS service that helps protect your connection from malicious sites and can bypass some local censorship. | [https://quad9.net/](https://quad9.net/) |

## 3. Tools for the "Hide and Save" Protocol (Encryption & Data)

| Tool | Purpose | FOSS Project Link |
| :--- | :--- | :--- |
| **VeraCrypt** | The standard FOSS tool for creating highly encrypted "vaults" or containers on your computer, USB drive, or even encrypting a whole disk. | [https://www.veracrypt.fr/](https://www.veracrypt.fr/) |
| **GnuPG** (or similar OpenPGP tool) | Used for advanced file and email encryption and verifying the source of a file. Critical for secure communication and document signing. | [https://gnupg.org/](https://gnupg.org/) |
| **Filen** | A secure, zero-knowledge cloud storage service. Your files are encrypted *before* they leave your device, ensuring only you can read them. | [https://filen.io/](https://filen.io/) |
