# "Be Invisible" Protocol: Personal Safety & Avoiding Danger

**Goal:** Minimize your exposure and risk when facing an immediate, physical threat (environmental, hostile, or accidental).
*Focus: Simple, instinctual steps to minimize risk, hide, or escape.*

| Step | Action: What You Must Do Now | Why This Saves You (Survival Rationale) | Safety Focus |
| :--- | :--- | :--- | :--- |
| **1. The Situational Pause** | Stop immediately and **look, listen, and smell** before you react. Identify the source of the danger and the safest direction of cover/escape. | Panic wastes precious seconds. A quick assessment helps you move *away* from the danger and *toward* safety. | *Situational Awareness* |
| **2. Seek Hard Cover** | If shots or explosions are a threat, immediately move behind the **hardest, thickest object** available (a concrete wall, a large tree, a sturdy vehicle engine block). | This provides physical protection against shrapnel and projectiles; soft cover (like thick bushes or wood fences) is not enough. | *Physical Safety (Immediate Action)* |
| **3. Go Unseen** | Stay low and avoid windows or open lines of sight. If surveillance is a risk, avoid looking directly at cameras or carrying bright, identifiable objects. | Reduces the chance of being targeted, recorded, or identified by an adversary. **Blending in is safety.** | *Personal Security (Low-Profile)* |
| **4. Hands Up, Hands Visible** | If you are stopped or detained, immediately place your **hands in plain view** (e.g., on your head or shoulders). Avoid sudden movements. | This reduces perceived threat and minimizes the risk of a violent response from those confronting you. | *Immediate Action (Compliance)* |
| **5. Leave the Device** | If your phone is seized or you are forced to unlock it, provide access, but **DO NOT** mention or open your **"Secret Vault"** (encrypted folder). | The physical safety of your person is paramount. Your secure data vault is designed to protect your most critical files even if your device is compromised. | *Personal Safety over Data* |
