# Foundational References for Resilience Protocols

## Conclusion of Protocols

1.  **The "Go Quiet" Protocol** (Digital Security)
2.  **The "Connect Smart" Protocol** (Digital Resilience)
3.  **The "Hide and Save" Protocol** (Data Security)
4.  **The "Move Fast, Pack Light" Protocol** (Evacuation)
5.  **The "Be Invisible" Protocol** (Personal Safety)
6.  **The "Call for Aid" Protocol** (Seeking Help)

This list is designed for organizations or individuals who wish to expand, adapt, or understand the foundational principles of these six protocols.

## 1. Digital Security and FOSS Resources

These organizations are the standard-bearers for open-source, non-commercial digital safety guides for high-risk individuals.

| Organization | Resource/Link | Relevance to Protocols |
| :--- | :--- | :--- |
| **Electronic Frontier Foundation (EFF)** | Surveillance Self-Defense Guide [1](https://www.eff.org/pages/surveillance-self-defense) | Foundational principles for "Go Quiet" and "Hide and Save," emphasizing secure technology and behavioral practices. |
| **Front Line Defenders** | Digital Security Resources [2](https://www.frontlinedefenders.org/en/digital-security-resources) | Provides open-source curricula and guides for activists and human rights defenders in high-risk zones. |
| **Global Investigative Journalism Network (GIJN)** | Digital Security Resource [3](https://gijn.org/resource/digital-security/) | Offers practical advice and self-diagnostic tools for users facing digital attacks (relevant to the "5-Minute Stress Test" concept). |

## 2. Physical Safety, Emergency Logistics, and Risk Management

These organizations provide established frameworks for crisis management, focusing on staff safety, evacuation, and global response logistics.

| Organization | Resource/Link | Relevance to Protocols |
| :--- | :--- | :--- |
| **International Federation of Red Cross and Red Crescent Societies (IFRC)** | Emergency Response Framework (ERF) [4](https://www.ifrc.org/sites/default/files/2025-01/IFRC%20Emergency%20Response%20Framework%202025.pdf) | Provides global guidance on rapid response and action, aligning with the urgency of the "Move Fast" and "Call for Aid" logistics. |
| **UN Office for Disaster Risk Reduction (UNDRR)** | Sendai Framework for Disaster Risk Reduction 2015-2030 [5](https://www.undrr.org/publication/sendai-framework-disaster-risk-reduction-2015-2030) | The global blueprint for reducing disaster risk, which provides the strategic context for all preparedness and evacuation planning. |
| **Global Interagency Security Forum (GISF)** | Security Risk Management: A Basic Guide for Smaller NGOs [6](https://gisf.ngo/wp-content/uploads/2017/06/Security-Risk-Management-A-basic-guide-for-smaller-NGOs.pdf) | Highly relevant guidance for understanding and minimizing risk, directly supporting the "Be Invisible" protocol. |

## 3. Historical/Foundational Survival Principles (Supporting All Protocols)

These public-domain resources offer timeless, hard-won survival lessons, providing a historical grounding for the physical safety protocols.

| Resource | Link | Relevance to Protocols |
| :--- | :--- | :--- |
| **FM 21-22 Watermanship 1944** | Public Domain Archive [7](https://archive.org/details/FM21-22) | A WWII-era U.S. War Department manual, now in the public domain, offering basic, foundational knowledge on water survival and resilience. |
