# "Move Fast, Pack Light" Protocol: Evacuation Plan & Action

**Goal:** Execute a rapid, safe, and organized departure from a dangerous area.
*Focus: What to prepare, what to take, and the sequence of actions for leaving immediately.*

| Step | Action: What You Must Do Now | Why This Saves You (Survival Rationale) | Gear/Action Focus |
| :--- | :--- | :--- | :--- |
| **1. The Grab-and-Go Bag** | Have one small, light bag pre-packed with essentials: **critical documents** (IDs, insurance copies, cash), **medicine**, and a **fully charged power bank.** | This is your "Go Bag." If you have only 60 seconds to leave, this bag ensures you take what you absolutely cannot replace. | *Preparation (Physical Security)* |
| **2. Secure Your Data** | Confirm your phone/computer has **Full Disk Encryption (FDE)** enabled and your **"Secret Vault"** is up to date (per the "Hide and Save" Protocol). | You may be separated from your devices. This protects your information from being read if they are seized or lost. | *Digital Security (FOSS Principle)* |
| **3. Know Your Routes** | Memorize at least **two different routes** to leave your area that avoid main roads. Focus on footpaths or less-used side streets. | Main roads will be clogged with traffic or monitored. Multiple escape paths increase your chance of success. | *Preparation (Situational Awareness)* |
| **4. Essential Clothing** | Before leaving, put on **sturdy shoes/boots**, long pants, and a warm layer, regardless of the weather outside. | Protects your feet and skin from injury, and helps regulate body temperature during extended movement. | *Immediate Action (Personal Safety)* |
| **5. Communicate Your Route** | **ONLY** use your secure messaging app (**Signal**) to tell **one trusted contact** your intended direction of travel and an estimated check-in time. | Ensures someone knows where to look for you, but minimizes the number of people who could expose your movements. | *Communication (Secure FOSS Use)* |

