# Connect Smart

##The "Connect Smart" Protocol: Resilient Connectivity

**Goal:** Secure your network connection and maintain access to critical information when the internet is slow, monitored, or completely unavailable.

This protocol focuses on protecting your data stream and maintaining access even when you can't trust the local network infrastructure.

| Step | Action: What You Must Do Now | Why This Saves You (Survival Rationale) | FOSS/Resilience Tool or Practice |
| :--- | :--- | :--- | :--- |
| **1. Check the Lock** | Before reading or sending anything sensitive on a website, **always look for the small lock icon** next to the website address. **If the lock is missing, DO NOT enter data.** | The lock icon means your connection is secure (encrypted). No lock means local surveillance can read everything you send, including passwords. | *Security Practice (HTTPS/Encryption)* |
| **2. Immediately Disconnect** | If you are working on a critical document or receive an alert, **physically disconnect** from the internet (unplug the cable, or turn off Wi-Fi/cellular data). | Complete physical isolation (**Air-Gapping**) prevents surveillance or malicious software from accessing your data while you work on it. | *Physical Security/Air-Gapping* |
| **3. Use Trusted DNS** | If possible, ask a trusted, technical person to switch your computer or phone's DNS to a resilient FOSS service like **Quad9**. | This helps you bypass local internet censorship or restrictions, allowing you to reach critical emergency sites when the normal path is blocked. | **Quad9** (FOSS DNS Service) |
| **4. Avoid Public Charging** | **DO NOT** use public USB charging ports in airports, train stations, or cafes. Only charge your device from a wall socket or a trusted, dedicated power bank. | Public USB ports can be secretly configured to steal data or install software onto your phone the moment you plug it in (this is called "Juice Jacking"). | *Physical Security Practice* |
| **5. Offline Map and Info** | Before you enter a dangerous area, save essential information (maps, contact lists, emergency procedures) as **offline PDF files** on your device. | When the network fails completely, you still have the vital data needed to navigate and survive. | *Data Resilience Practice* |

