Markdown# How to Install OTFR Tools on Tails Linux

### Step 1: Get Tails
1. Go to https://tails.net/install/
2. Download the latest Tails USB image (.img)
3. **Verify the download** (critical — follow instructions on site)
4. Write it to a USB stick (≥8GB) using Tails Installer, Rufus, or Etcher

### Step 2: First Boot & Create Persistence
1. Boot from the Tails USB (restart computer → boot menu, usually F12/Esc)
2. At Welcome Screen:
   - Click **+** (Additional Settings)
   - Set an **Administration Password** (temporary, forgotten on shutdown)
3. Start Tails
4. Go to **Applications → Tails → Configure persistent storage**
5. Create persistence:
   - Choose your USB drive
   - Set a **strong passphrase** (write it down safely — lost = data gone)
   - Enable at minimum:
     - **Persistent Folder** (for tools)
     - Optional: **Dotfiles** (for custom configs), **Additional Software**
6. Reboot Tails
7. At Welcome Screen: Enter passphrase to unlock persistence

### Step 3: Add OTFR Tools
1. In Tails, open Tor Browser
2. Download the latest OTFR package:  
   https://treemagic.org/OTFR/tools/OTFR-Tails-Package.zip
3. Open **Places → Persistent** (folder appears on desktop after unlock)
4. Extract the zip contents directly into the Persistent folder:
Persistent/
└── OTFR/
├── Emergencies/
├── Low-Tech-Tools/
└── Situation-Maps/
text5. Create shortcuts (optional but helpful):
- Right-click important files/folders → **Make Link**
- Drag links to Desktop

### Step 4: Use the Tools
- Unlock persistence at every boot
- Tools are in Persistent/OTFR/
- Maps work in Tor Browser (bookmarks provided)
- All network traffic automatically goes through Tor

### Updates
- Tails updates itself securely (follow prompts)
- For OTFR updates: download new package and replace in Persistent/OTFR/

### Security Notes
- Never use the administration password for regular work
- Shutdown completely removes temporary session
- Persistent volume is strongly encrypted

Questions? Contact: mark@eireicon.org

Go forth and do good.
